﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace slideshow
{
    public partial class Form1 : Form
    {
        string dir, fname, ext,path;
        string[] flist = new string[5000];
        string w1;

        int[] chk = new int[5000];
        int Total,I, P, P1,Pe, Stop;
        int PX, PY;
       

        public Form1()
        {
            InitializeComponent();
        }

        //****************************************SubRoutine****************************
       private void SetForm(String fname)
        {
            int w;

            int crt_h = System.Windows.Forms.Screen.PrimaryScreen.Bounds.Height;
            int crt_w = System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width;


            Width = 1000;
            pictureBox1.Image = Image.FromFile(path);

            int x = pictureBox1.Image.Width;
            int y = pictureBox1.Image.Height;
            if(x<y)
            {
                float r = (float)x / y;
                
                Height = (int)(Width * 0.75)+110;

            }
            else
            {
                Height = crt_h-100;

                float r = (float)x / y;

                Width = (int)(Height*r);

                w = pictureBox1.Width;
                int h = (int)(w / r);
                pictureBox1.Height = h;

            }

            pictureBox1.Image.Dispose();
        }

        private void Disp(int i)
        {
            if (Total == -1)
                return;

            
            if (Pe==i)
            {
                if (checkBox1.Checked == false)  //繰り返し
                {
                    Stop= 255;
                    checkBox1.ForeColor = Color.Red;
                    button11.Enabled = true;
                    button10.Enabled = false;
                    button10.BackColor = System.Drawing.SystemColors.Control;
                }

            }
            if (i > Total)
            {
                i = 0;
                P = 0;

            }

      //      if (flist[i] == null) return;
            if (pictureBox1.Image != null)
            { pictureBox1.Image.Dispose(); }

            I = i;  //use gview, チェック

            pictureBox1.Image = Image.FromFile(flist[I]);

            label2.Text = flist[i];    //File Name

            label13.Text = (i+1).ToString();  //ポインタ－

            if (chk[i]==255)                   //mark
            {
                label2.ForeColor = Color.Red;  //Ext
            }
            else
            {
                label2.ForeColor = Color.Black;
            }

            label14.Text = P1.ToString();  //number of Mark
            
        }

      private void TakeFile()
        {
            int i;
            // jpg"ファイルをすべて取得する
            //AllDirectories　　サブフオルダ－も含め全て列挙
            //TopDirectoryOnly　そのフオルダ－のみ列挙


            System.IO.DirectoryInfo di = new System.IO.DirectoryInfo(dir);
            System.IO.FileInfo[] files = di.GetFiles("*" + ext, System.IO.SearchOption.TopDirectoryOnly);

            i = 0;
            foreach (System.IO.FileInfo f in files)
            {
                flist[i] = f.FullName;
                i++;
            }

            Total = i - 1;

            string[] flist1 = new string[Total+1];
            for(i=0;i<(Total+1);i++)
            {
                flist1[i] = flist[i];

            }

            Array.Sort(flist1);

            for (i = 0; i <( Total + 1); i++)
            {
                flist[i] = flist1[i];

            }

            label12.Text = i.ToString();  //Total
        }

      private void ChkClr()
        {
            int i;
            for (i = 0; i < Total + 1; i++)
            {
                chk[i] = 0;
            }
            P1 = 0;
            label14.Text = P1.ToString();  //number of Check
        }
        
    private string TakeDir()
        {
            folderBrowserDialog1.ShowDialog();
            return  folderBrowserDialog1.SelectedPath;

        }

     private void button_chg(int i)
        {
            switch (i)
            {
                case 1:
                    button5.Enabled = true;  //コピ－参照
                    button6.Enabled = true;  //コピ－開始

                    button7.Enabled = false; //Mov参照
                    button7.BackColor = System.Drawing.SystemColors.Control;

                    button8.Enabled = false; //Mov開始
                    button8.BackColor = System.Drawing.SystemColors.Control;

                    button9.Enabled = false; //Del
                    button9.BackColor = System.Drawing.SystemColors.Control;
                    button20.Enabled = false;
                    button20.BackColor = System.Drawing.SystemColors.Control;

                    break;
                case 2:
                    button5.Enabled = false;
                    button5.BackColor = System.Drawing.SystemColors.Control;
                    button6.Enabled = false;
                    button6.BackColor = System.Drawing.SystemColors.Control;

                    button8.Enabled = true;  //Ｍｏｖｅ開始
                    button7.Enabled = true; //Directory参照

                    button9.Enabled = false;
                    button9.BackColor = System.Drawing.SystemColors.Control;

                    button20.Enabled = false;
                    button20.BackColor = System.Drawing.SystemColors.Control;

                    break;
                case 3:  //del
                    button6.Enabled = false; //Copy
                    button5.Enabled = false; //Copy
                    button7.Enabled = false; //Move
                    button8.Enabled = false; //MoveDirectory参照
                    button20.Enabled = false; //Rename

                    button6.BackColor = System.Drawing.SystemColors.Control; //Copy
                    button7.BackColor = System.Drawing.SystemColors.Control; //Mov参照
                    button5.BackColor = System.Drawing.SystemColors.Control; //Copy
                    button8.BackColor = System.Drawing.SystemColors.Control; //Mov
                    button20.BackColor = System.Drawing.SystemColors.Control; //Mov
                    break;
                case 4:  //rename
                    button6.Enabled = false; //Copy
                    button5.Enabled = false; //Copy
                    button7.Enabled = false; //Move
                    button8.Enabled = false; //Move
                    button9.Enabled = false; //Del

                    button6.BackColor = System.Drawing.SystemColors.Control; //Copy
                    button7.BackColor = System.Drawing.SystemColors.Control; //Mov参照
                    button5.BackColor = System.Drawing.SystemColors.Control; //Copy
                    button8.BackColor = System.Drawing.SystemColors.Control; //Mov
                    button9.BackColor = System.Drawing.SystemColors.Control; //Del

                    break;

            }
        }
        private void button4_Click(object sender, EventArgs e) //timerよりcall
        {
            timer1.Enabled = false;

            Disp(P);

            timer1.Enabled = true;

            if (button10.Enabled == false)
            {
                if (checkBox1.Checked == false)
                {
                    if (Stop == 255)
                    {
                        timer1.Enabled = false;
                        button15.Enabled = true;
                        button12.Enabled = true;
                        return;
                    }
                }
            }
            P++;

        }

        //******************* tagPage2 **************************************************


        private void tabPage2_Enter(object sender, EventArgs e)  //ペ－ジ2の初期化
        {
        if (P1 == 0)
            {
                MessageBox.Show("チェックされたフアイルがありません", "注意", MessageBoxButtons.OK);
                this.tabControl1.SelectedTab = tabPage1;
               
                return;
            }


          if (radioButton1.Checked==true)  //Copy
            {
                button_chg(1);

            }
            else
            {
                if (radioButton2.Checked == true)  //Move
                {
                    button_chg(2);

                }
                else   //Delete
                {
                    if (radioButton3.Checked == true)
                    {
                        button_chg(3);
                    }
                    else
                    {
                        button_chg(4);
                    }
                }

            }

          label11.Text = P1.ToString();  //number of Check
        }

        private void radioButton2_MouseDown(object sender, MouseEventArgs e)  //転送
        {
            button_chg(2);
        }

        private void radioButton3_MouseDown(object sender, MouseEventArgs e)  //削除
        {
            button_chg(3);
            button9.Enabled = true;
          
        }

        private void radioButton1_MouseDown(object sender, MouseEventArgs e)  //Copy
        {
            button_chg(1);
        
        }
        private void radioButton4_MouseDown(object sender, MouseEventArgs e) //Rename
        {
            button_chg(4);
            button20.Enabled = true;
        }

        private void button5_Click(object sender, EventArgs e)  //Ｃｏｐｙ　参照
        {
            textBox2.Text = TakeDir();
        }

        private void button7_Click(object sender, EventArgs e)  //移動　参照
        {
            textBox3.Text = TakeDir();
        }

        private void tabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            timer1.Enabled = false;
            button11.Enabled = true;  //再開
            button10.Enabled = false; //Stop
            button10.BackColor = System.Drawing.SystemColors.Control;
        }



        private void button6_Click(object sender, EventArgs e)  //コピ-開始
        {
            string wdir, wpath; ;
            int i;

            if (textBox2.Text == "")
            {
                MessageBox.Show("コピ－先が指定されていません", "注意", MessageBoxButtons.OK);
                return;
            }
            for (i = 0; i < Total+1; i++)
            {
                if(chk[i] ==255)
                {
                    fname = System.IO.Path.GetFileName(flist[i]);
                    wdir = textBox2.Text;
                    wpath = wdir + "\\" + fname;
                    if ( ! System.IO.File.Exists(wpath))
                    {
                        System.IO.File.Copy(flist[i], wpath);
                    }


                }
            }

            MessageBox.Show("コピ－が終わりました", "報告", MessageBoxButtons.OK);
        }

 
 

        private void button8_Click(object sender, EventArgs e)  // Move 移動先に同じフアイルがあると移動できない
        {
            string wdir, wpath;
            string w;
            int movflg,w_P1;


            int i;

            if (textBox3.Text == "")
            {
                MessageBox.Show("移動先が指定されていません", "注意", MessageBoxButtons.OK);
                return;
            }
            movflg = 0;

            for (i = 0; i < Total + 1; i++)
            {
                if (chk[i] == 255)
                {
                    fname = System.IO.Path.GetFileName(flist[i]);
                    wdir = textBox3.Text;
                    wpath = wdir + "\\" + fname;

                   

                    if (!System.IO.File.Exists(wpath))
                    {
                        w = "";
                        w1 = "";

                        try
                        {
                            if ((pictureBox1.Image != null))
                             { pictureBox1.Image.Dispose(); }  //これにより使用中..のエラ－が出なくなる

                            System.IO.File.Move(flist[i], wpath);
                            movflg++;
                        }
                        catch
                        {
                            w1 = flist[i] + "が移動できませんでしたが、他は";

                        }
                    }
                }
               
            }

            w_P1 = P1-1;

            TakeFile();
            ChkClr();
           
            label2.Text = "";
            label2.ForeColor = Color.Black;
            label13.Text = P.ToString();

            pictureBox1.Image = null;

            movflg--;

            if(movflg != w_P1)
            {
                w="同名のフアイルがあり移動きませんでした";
                MessageBox.Show(w, "報告", MessageBoxButtons.OK);
            }
            else
            {
                w = w1 + "移動が終わりました";
                MessageBox.Show(w, "報告", MessageBoxButtons.OK);

            }

            if (Total >0)
            {
                if(P>Total)
                {
                    P = 0;
                }
                Disp(P);
            }

           tabControl1.SelectedIndex = 0;
        }

        private void button20_Click(object sender, EventArgs e)  //Rename
        {
            string w,wn;

            int i,n,len,len1;
            w = textBox5.Text;
            len = w.Length;
            w1 = "";

            for (i = 0; i < Total + 1; i++)
            {
                if (chk[i] == 255)
                {
                    path = flist[i];
                    ext = System.IO.Path.GetExtension(path);
                    fname = textBox4.Text;   
                    if(fname=="")
                    {
                        MessageBox.Show(w1 + "新しいフアイル名を指定してください", "警告", MessageBoxButtons.OK);
                        return;

                    }

                    wn = "00000" + w;
                    len1 = wn.Length;

                    wn = wn.Substring(len1-len,len);

                    path = System.IO.Path.GetDirectoryName(path)+"\\"+fname+wn;
                    n = Int32.Parse(w);
                    n++;
                    w = n.ToString();
                   
                    path = path + ext;

                    try
                     {
                       if ((pictureBox1.Image != null))
                          { pictureBox1.Image.Dispose(); }  //これにより使用中..のエラ－が出なくなる

                      System.IO.File.Move(flist[i], path);
                      }
                    catch
                      {
                        w1 =w1+flist[i] +",";

                      }
                                       
                }
            }
            TakeFile();
            ChkClr();
            Disp(0);

            if(w1 !="")
            {
                MessageBox.Show(w1 + "Renameできませんでした", "警告", MessageBoxButtons.OK);

            }
            else
            {
                MessageBox.Show("Renameが終わりました", "報告", MessageBoxButtons.OK);
            }

            tabControl1.SelectedIndex = 0;
        }
        private void button9_Click(object sender, EventArgs e)  //Del
        {
            int i = 0;
            w1 = "";
            
            for (i = 0; i <Total+1; i++)
            {
               if (chk[i] == 255)
                {
                    try
                    {
                        if ((pictureBox1.Image != null))
                         { pictureBox1.Image.Dispose(); }  //これにより使用中..のエラ－が出なくなる

                        System.IO.File.Delete(flist[i]);
                      
                    }
                    catch
                    {
                        w1 = flist[i] + "使用中のフアイルの操作が出来ないため削除出来ませんでしたが、他は";
                    }

                
                }
            }

            TakeFile();
            ChkClr();
          
            label2.Text = "";
            label2.ForeColor = Color.Black;
            label13.Text = P.ToString();

            pictureBox1.Image = null;

            if (Total > 0)
            {
              if (P > Total)
                {
                    P = 0;
                }
               Disp(P);
            }

            MessageBox.Show(w1+"削除が終わりました", "報告", MessageBoxButtons.OK);
            tabControl1.SelectedIndex = 0;
        }


        //*************************  tabPage1 ************************************************



        private void button13_Click(object sender, EventArgs e)  // Exit
        {
              Close();
        }


        private void checkBox1_CheckedChanged(object sender, EventArgs e) // Repeat yes/no
        {
            if(button10.Enabled==false)
            {
                return;
            }

            if (Stop == 255)
            {
                if (checkBox1.Checked == true)
                {
                    timer1.Enabled = true;
                    Stop = 0;
                    checkBox1.ForeColor = Color.Black;
                }

            }
        }


        private void button2_Click(object sender, EventArgs e) //Timerの間隔再設定
        {
            timer1.Interval = Int32.Parse(textBox1.Text);
        }



        private void Form1_Load(object sender, EventArgs e)
        {
            button14.Top = 3;  // リセット
 


            button3.Top = 3;    //チェック
        
            button10.Top = 3;   //　Stop
            button11.Top = 3;  //再開


            button12.Top = 3;  // <-
            button1.Top = 3;   //開始
            button2.Top = 3; //変更
            button15.Top = 3;  //->
            button17.Top = 3;
            button14.Top = 3;

            button13.Top = 37;    // Exit
            button18.Top = 3;    //GView
            button19.Top = 3;    //Img
            

            textBox1.Top = 7;

            label1.Top = 12;
 
            label2.Top = 34;

            label12.Top = 11;
            label13.Top = 11;
            label14.Top = 11;

            pictureBox1.Left = 0;
            pictureBox1.Top = 63;
        }


        private void tabControl1_Click(object sender, EventArgs e)
        {
            int w, h,p;

           p= tabControl1.SelectedIndex;

            if (Total==0)
            { 
                tabControl1.SelectedIndex = 0;
 
                return;
            }

           switch (p)
            {
              case 0:

                    try
                    {
                        w = pictureBox1.Image.Width;
                        h = pictureBox1.Image.Height;
          
                    }
                    catch (Exception)
                    {
                        ;
                    }
                    break;
/*
                case 1:
                    if (pictureBox1.Image != null)
                    {
                        pictureBox1.Image.Dispose(); //これにより使用中..のエラ－が出なくなる
                    }

                   if (pictureBox2.Image != null)
                    {
                        pictureBox2.Image.Dispose(); //これにより使用中..のエラ－が出なくなる
                    }

                    break;
*/


            }

        }
        private void button17_Click(object sender, EventArgs e)
        {
            for (I = 0; I < Total + 1; I++)
            {
                chk[I] = 255;
            }
            label2.ForeColor = Color.Red;
            P1 = Total+1;
            label14.Text = P1.ToString();
        }

        private void button18_Click(object sender, EventArgs e)
        {
            if (flist[I]=="")
            {
                return;
            }

            timer1.Enabled = false;
            /*
                        String s = Application.ExecutablePath;
                        String d = System.IO.Path.GetDirectoryName(s);
                        s = "D:\\OneDrive\\MyProg\\JpegAna142\\JpegAnalyzer.exe";
            */
            string s = Application.ExecutablePath;
            s = Path.GetDirectoryName(s) + "\\" + "JpegAna1\\JpegAnalyzer.exe";

            System.Diagnostics.Process.Start(s, flist[I]);

        }

        private void button19_Click(object sender, EventArgs e)
        {
            string d;

            if (flist[I]=="")
            {
                return;
            }
            timer1.Enabled = false;

            String s = Application.ExecutablePath;
            d = System.IO.Path.GetDirectoryName(s);
           
           s =d+ "\\Img.exe";
            Clipboard.Clear();

            d = flist[I] + "," + PX.ToString() + "," + PY.ToString();
            Clipboard.SetDataObject(d);

            // Clipboard.SetDataObject(flist[I]);

            System.Diagnostics.Process.Start(s);
        }


        private void pictureBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if(pictureBox1.Image== null)
            {
                return;
            }

            Point p=e.Location;
            PX = p.X;
            PY = p.Y;
            int x = pictureBox1.Image.Width;
            int y= pictureBox1.Image.Height;
            float r,r1;
           
            int x1=pictureBox1.Width;

            int y1= pictureBox1.Height;
            r1 =(float) y / y1;

            r = (float)x / x1;
            PX = (int)(PX * r);
            PY = (int)(PY * r1);
        }


        private void button14_Click(object sender, EventArgs e)  // Reset
        {
            ChkClr();
            label2.ForeColor = Color.Black;
        }

        private void button15_Click(object sender, EventArgs e)  // ->
        {
            P = P + 1;
            if (P > Total)
            {
                P = 0;
            }
            Disp(P);
        }
        private void button12_Click(object sender, EventArgs e)　　// <-
        {
            P = P - 1;
            if (P < 0) P = Total;
            Disp(P);
        }

        private void button11_Click(object sender, EventArgs e)  //再開
        {
            button12.Enabled = false; //<-
            button12.BackColor = System.Drawing.SystemColors.Control; //ボタンの色を薄くする
            button15.Enabled = false; //->
            button15.BackColor = System.Drawing.SystemColors.Control; //ボタンの色を薄くする
            button10.Enabled = true;

            button11.Enabled = false;
            button11.BackColor = System.Drawing.SystemColors.Control; //ボタンの色を薄くする
            checkBox1.Checked = true;
            timer1.Enabled = true;
            checkBox1.ForeColor = Color.Black;
            P++;
            Stop = 0;
        }


        private void button10_Click(object sender, EventArgs e) //Stop
        {
            timer1.Enabled = false;
            button12.Enabled = true; //<-
            button11.Enabled = true; //再開
            button10.Enabled = false; // Stop
            button10.BackColor = System.Drawing.SystemColors.Control;
            button15.Enabled = true; //->
            checkBox1.Checked = false;
 
        }


        private void button3_Click(object sender, EventArgs e) //Check
        {
            timer1.Enabled = false;
           
            // IはDisp()で代入され、表示されているＦｉｌｅ　ナンバ－

            if (chk[I] == 255)
            {
                chk[I] = 0;
                P1--;
                label2.ForeColor = Color.Black;
                
            }
            else
            {
                chk[I] = 255; //Disp P++
                P1++;
                label2.ForeColor = Color.Red;
            }
            label14.Text = P1.ToString();
            if (button10.Enabled != false)
            {
                timer1.Enabled = true;
            }
        }

        private void button1_Click(object sender, EventArgs e)  //開始
        {
            int i;
            string fname;

            openFileDialog1.FileName="";
            openFileDialog1.ShowDialog();

            path = openFileDialog1.FileName;

            if (path =="") return;
            fname = System.IO.Path.GetFileName(path);
            dir = System.IO.Path.GetDirectoryName(path);
            ext = System.IO.Path.GetExtension(path);
            ext=ext.ToLower();
            if (ext!=".jpg")
            {
                MessageBox.Show("JPGで無いようです", "警告", MessageBoxButtons.OK);

                return;
            }
            /*
                        Width = 1000;
                        pictureBox1.Image = Image.FromFile(path);

                        int x=pictureBox1.Image.Width;
                        int y=pictureBox1.Image.Height;
                        float r = (float)x / y;
                        Height = (int)(Width/ r)+110;

                        int w = pictureBox1.Width;
                        int h = (int)(w / r);
                        pictureBox1.Height = h;

                        pictureBox1.Image.Dispose();
             */

            SetForm(fname);

            TakeFile();

            timer1.Interval = Int32.Parse(textBox1.Text);
            timer1.Enabled = false;
            for(i=0;i<Total;i++)
            {
              if(flist[i].IndexOf(fname)>0)
                {
                    break;
                }
            }
            Pe = i - 1;
            if(Pe<0)
            {
                Pe = Total;
            }

            P = i;

            Disp(P);
            button3.Enabled = true;

            button10.Enabled = true;
            button11.Enabled = false;
            //button11.BackColor = System.Drawing.SystemColors.Control; //ボタンの色を薄くする

            button12.Enabled = true;
           // button12.BackColor = System.Drawing.SystemColors.Control; //ボタンの色を薄くする

            button15.Enabled = true;
           // button15.BackColor = System.Drawing.SystemColors.Control; //ボタンの色を薄くする

            button13.Enabled = true;
            button14.Enabled = true;
            button17.Enabled = true;  //All
            button18.Enabled = true; //Anal
            button19.Enabled = true;   //Img.exe

            Stop = 0;
            P1 = 0;
            ChkClr();
            label2.ForeColor = Color.Black;
 //           button10_Click(sender, e);
            button11_Click(sender, e);
        }

        //*********************************************************************************************


    }
}


